//
//  GSEventHandleProtocol.h
//  GSCommonKit
//
//  Created by net263 on 2021/10/21.
//  Copyright © 2021 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GSLoginParams.h"
#import "GSEventHandleConst.h"
#import "GSSubjective.h"
NS_ASSUME_NONNULL_BEGIN

@protocol GSEventHandleProtocol <NSObject>
-(void)updateEventHandleParam:(GSLoginParams*)params;
/*
 *上席、下席
 *action:1 上席  2 下席
 */
-(void)commitPodiumTask:(int)action;

/*
 *提交打提卡数据
 *@param answerId 答题卡ID
 */
-(void)commitAnswerTask:(NSString*)answerId;

/*
 *提交试卷数据
 *@param paperId 试卷ID topicTotal 题目总数 answernNum 答对总数
 */
-(void)commitPagerTask:(NSString*)paperId topicTotal:(int)topicTotal answernNum:(int)answernNum;

/*
 *提交举手数据
 */
-(void)commitHandupTask;

/*
 *发起懂不懂任务
 *@param dst:广播范围
 */
-(void)commitPublishUnderstandTask:(GSEventBroadDst)dst;

/*
 *确认懂不懂任务
 *@param understandId 懂不懂ID
 *@param isConfirm YES： 懂 NO：不懂
 */
-(void)commitConfirmUnderstandTask:(NSString*)understandId confirm:(BOOL)isConfirm;

/**
 *发布答题卡主观题
 *@param subjective:主观题对象，需用户创建，主观题ID及问题ID用户可不传，SDK内部生成，发题时answers数组不需要填写
 *@param dst 广播范围
 */
-(void)commitSubjectivePublishTask:(GSSubjective*)subjective dst:(GSEventBroadDst)dst;

/**
 *学生答题
 *@param subjective:主观题对象，根据收到的发题的对象，答题时直接填充answers数组
 *@param dst 广播范围
 */
-(void)commitSubjectiveReplyTask:(GSSubjective*)subjective dst:(GSEventBroadDst)dst;


/**
 *结束答题
 *@param subjectiveId 主观题ID
 *@param dst 广播范围
 */
-(void)commitSubjectiveFinishTask:(NSString*)subjectiveId dst:(GSEventBroadDst)dst;
/*
 *查询外推汇总数据
 *@param queryTypeParams 要查询的参数数组 类型为：GSBHVCLIENTEVENTPARAMS
 *@param block 查询结果回调
 */
-(void)queryClientEventTask:(NSArray*)queryTypeParams  block:(void(^)(NSDictionary*data))block;


-(void)parseGSEventCommandMsg:(NSString*)msg;
@end

NS_ASSUME_NONNULL_END
